/*
 * Decompiled with CFR 0.152.
 */
package org.radrails.rails.internal.ui;

import com.aptana.core.projects.templates.IProjectTemplate;
import com.aptana.ruby.ui.wizards.WizardNewRubyProjectCreationPage;
import java.io.File;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.radrails.rails.internal.ui.Messages;
import org.radrails.rails.ui.RailsUIPlugin;

public class WizardNewRailsProjectCreationPage
extends WizardNewRubyProjectCreationPage {
    private static final String ICON_WARNING = "icons/warning_48.png";
    private Button runGenerator;
    private CLabel projectGenerationErrorLabel;
    private boolean hasRailsAppFiles;
    private Composite projectGenerationControls;

    public WizardNewRailsProjectCreationPage(String pageName, IProjectTemplate projectTemplate) {
        super(pageName, projectTemplate);
    }

    protected Composite createGenerateGroup(Composite parent) {
        Composite projectGenerationGroup = super.createGenerateGroup(parent);
        this.projectGenerationErrorLabel = new CLabel(projectGenerationGroup, 64);
        this.projectGenerationErrorLabel.setText(Messages.WizardNewRailsProjectCreationPage_cannotCreateProjectMessage);
        this.projectGenerationErrorLabel.setImage(RailsUIPlugin.getImage(ICON_WARNING));
        return projectGenerationGroup;
    }

    protected void createGenerationOptions(Composite projectGenerationControls) {
        this.runGenerator = new Button(projectGenerationControls, 16);
        this.runGenerator.setText(Messages.WizardNewRailsProjectCreationPage_StandardGeneratorText);
        super.createGenerationOptions(projectGenerationControls);
        this.noGenerator.setSelection(false);
        this.runGenerator.setSelection(true);
        this.projectGenerationControls = projectGenerationControls;
    }

    protected void selectGitCloneGeneration() {
        super.selectGitCloneGeneration();
        this.runGenerator.setSelection(false);
    }

    protected boolean validatePage() {
        if (!super.validatePage()) {
            return false;
        }
        this.hasRailsAppFiles = this.hasRailsApp(this.getLocationText());
        if (this.hasRailsAppFiles) {
            this.setTopControl((Control)this.projectGenerationErrorLabel);
        } else {
            this.setTopControl((Control)this.projectGenerationControls);
        }
        return true;
    }

    private boolean hasRailsApp(String path) {
        File projectFile = new File(path);
        File env = new File(projectFile, "config" + File.separator + "environment.rb");
        return env.exists();
    }

    protected boolean runGenerator() {
        return !this.hasRailsAppFiles && this.runGenerator.getSelection();
    }
}

